% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prediction_model.v16.R
\name{rt_empirical}
\alias{rt_empirical}
\title{Empirical estimate of \eqn{R_t}}
\usage{
rt_empirical(cases, window_size, serial_mean, serial_var)
}
\arguments{
\item{cases}{Vector of (confirmed) cases.}

\item{window_size}{The maximum value for the serial interval.}

\item{serial_mean}{Mean of the serial interval on the log scale.}

\item{serial_var}{Variance of the serial interval on the log scale.}
}
\value{
A vector of same length as cases, giving the empirical estimate of the effective reproductive number over time.
}
\description{
Compute empirical \eqn{R_t}, via Cori et al. (2013) method.
}
