/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.hups;

import umontreal.iro.lecuyer.hups.KorobovLattice;

public class KorobovLatticeSequence
extends KorobovLattice {
    int base;
    int inverse;
    int n;

    public KorobovLatticeSequence(int n, int n2) {
        super(2, 3, 1);
        if (n2 <= 1) {
            throw new IllegalArgumentException("KorobovLatticeSequence:   Multiplier a must be > 1");
        }
        this.a = n2;
        this.base = n;
    }

    public double getCoordinate(int n, int n2) {
        if (n == 0) {
            return 0.0;
        }
        if (n2 == 0) {
            return this.radicalInverse(this.base, n);
        }
        int n3 = 1;
        int n4 = 0;
        while (n > 0) {
            n4 = n4 * this.base + n % this.base;
            n3 *= this.base;
            n /= this.base;
        }
        return (double)((long)n4 * this.modPower(this.a, n2, n3) % (long)n3) / (double)n3;
    }

    private void integerRadicalInverse(int n) {
        this.n = 1;
        this.inverse = 0;
        while (n > 0) {
            this.inverse = this.inverse * this.base + n % this.base;
            this.n *= this.base;
            n /= this.base;
        }
    }
}

