/*
 * Decompiled with CFR 0.152.
 */
package math;

import indice.Discriminant;
import indice.Friedman;
import indice.FriedmanTukey;
import indice.Indice;
import indice.KurtosisMin;
import java.io.File;
import java.util.Comparator;
import javalain.ea.SolutionEA;
import javalain.ea.operator.comparator.ObjectiveComparator;
import javalain.math.Calcul;
import javalain.math.fonction.Fct;
import math.Matrice;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FctIndice
extends Fct {
    private final double[] fct;
    private Indice indice;

    public FctIndice(String nom_fichier, String nom_indice) {
        this.nomFct = nom_fichier + " - " + nom_indice;
        this.nbVariable = 2;
        this.nbFctObjectif = 1;
        this.fct = new double[this.nbFctObjectif];
        this.lowerLimit = new double[this.nbVariable];
        this.upperLimit = new double[this.nbVariable];
        this.lowerLimit[0] = -1.0;
        this.upperLimit[0] = 1.0;
        this.lowerLimit[1] = -1.0;
        this.upperLimit[1] = 1.0;
        Matrice X = new Matrice("donnees" + File.separatorChar + nom_fichier + ".txt", 0);
        if (nom_indice.equals("Discriminant")) {
            this.indice = new Discriminant(X.spherique());
        } else if (nom_indice.equals("FriedmanTukey")) {
            this.indice = new FriedmanTukey(X.spherique());
        } else if (nom_indice.equals("Friedman")) {
            this.indice = new Friedman(X.spherique());
        } else if (nom_indice.equals("Kurtosis")) {
            this.indice = new KurtosisMin(X.spherique());
        }
    }

    public double[] compute(double[] x) {
        this.fct[0] = this.indice.calcul(Calcul.normaliseVecteur((double[])x));
        return this.fct;
    }

    public double[][] getFront() {
        if (this.front == null) {
            this.front = new double[1][this.nbVariable];
            for (int i = 0; i < this.nbVariable; ++i) {
                this.front[0][i] = 0.0;
            }
        }
        return this.front;
    }

    public Comparator<SolutionEA> comparator() {
        return new ObjectiveComparator(0);
    }
}

