/*
 * Decompiled with CFR 0.152.
 */
package ihm.graphique;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JPanel;
import util.GuiUtils;

public class ConvergenceIndice
extends JPanel {
    private float[] tabNb;
    private int indiceTab;
    private float min;
    private float max;
    private int largeur;
    private int hauteur;
    private int marge = 2;
    private int taille_point = 2;

    public ConvergenceIndice(int l, int h) {
        this.largeur = l;
        this.hauteur = h;
        this.tabNb = new float[500];
        this.indiceTab = -1;
        this.setMinimumSize(new Dimension(this.largeur, this.hauteur));
        this.setPreferredSize(new Dimension(this.largeur, this.hauteur));
    }

    public void raz() {
        this.indiceTab = -1;
        this.repaint();
    }

    public void addNombre(float f) {
        int taille;
        if (this.indiceTab == -1) {
            this.min = f;
            this.max = f;
        }
        if (this.indiceTab == (taille = this.tabNb.length) - 1) {
            int n_taille = taille * 120 / 100 + 1;
            float[] tab = this.tabNb;
            this.tabNb = new float[n_taille];
            System.arraycopy(tab, 0, this.tabNb, 0, taille);
        }
        if (f > this.max) {
            this.max = f;
        }
        if (f < this.min) {
            this.min = f;
        }
        this.tabNb[++this.indiceTab] = f;
        this.repaint();
    }

    public void paint(Graphics g) {
        g.setColor(GuiUtils.GRIS_238);
        g.fillRect(0, 0, this.largeur, this.hauteur);
        float echelleX = (float)(this.largeur - 2 * this.marge - this.taille_point) / (float)this.indiceTab;
        float echelleY = (float)(this.hauteur - 2 * this.marge - this.taille_point) / (this.max - this.min);
        g.setColor(Color.black);
        for (int i = 0; i <= this.indiceTab; ++i) {
            g.fillRect((int)((float)i * echelleX) + this.marge, this.hauteur - this.marge - this.taille_point - (int)((this.tabNb[i] - this.min) * echelleY), this.taille_point, this.taille_point);
        }
        if (this.indiceTab != -1) {
            g.setFont(GuiUtils.FONT_11);
            g.drawString(GuiUtils.SCIENTIFIQUE.format(this.max), this.largeur - 65, this.hauteur - 5);
        }
    }
}

