% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rd_query.R
\name{rd_query}
\alias{rd_query}
\title{Identification of queries}
\usage{
rd_query(
  ...,
  data = NULL,
  dic = NULL,
  variables = NA,
  expression = NA,
  negate = FALSE,
  event = NA,
  filter = NA,
  addTo = NA,
  variables_names = NA,
  query_name = NA,
  instrument = NA,
  report_title = NA,
  report_zeros = FALSE,
  by_dag = FALSE,
  link = list()
)
}
\arguments{
\item{...}{List containing the data, the dictionary and the event (if required). It may be the output of the `redcap_data` function.}

\item{data}{Data frame containing the data read from REDCap. If the list is given, this argument is not required.}

\item{dic}{Data frame containing the dictionary read from REDCap. If the list is given, this argument is not required.}

\item{variables}{Character vector of the names of the database variables to be checked.}

\item{expression}{Character vector of expressions to be applied to the selected variables.}

\item{negate}{Logical value which indicates whether the defined expression should be negated. Defaults to `FALSE`.}

\item{event}{The name of the REDCap event to be analyzed. If there are events in your REDCap project, you should use this argument in order to name the event to which the defined variables belong.}

\item{filter}{A filter to be applied to the dataset. For example, the branching logic of a determined variable can be applied using this argument.}

\item{addTo}{Data frame corresponding to a previous query data frame to which you can add the new query data frame. By default, the function always generates a new data frame without taking into account previous reports.}

\item{variables_names}{Character vector containing the description of each selected variable. By default, the function automatically takes the description of each variable from the dictionary of the REDCap project.}

\item{query_name}{Description of the query. It can be defined as the same one for all the variables, or you can define a different one for each variable. By default, the function defines it as `The value is [value] and it should not be [expression]'`.}

\item{instrument}{REDCap's instrument to which the variables belong. It can be defined as the same one for all the variables, or you can define a different one for each variable. By default, the function automatically selects the corresponding instrument of each variable from the dictionary of the REDCap project.}

\item{report_title}{Character string specifying the title of the report.}

\item{report_zeros}{Logical. If `TRUE`, the function returns a report containing variables with zero queries.}

\item{by_dag}{Logical. If `TRUE`, both elements of the output are grouped by the data access groups (DAGs) of the REDCap project.}

\item{link}{List containing project information used to create a web link to each query.}
}
\value{
A list with a data frame of 9 columns (10 columns, if the link argument is specified) meant to help the user identify each query and a table with the total number of queries per variable.
}
\description{
This function allows you to identify queries by the use a specific expression.
It can be used to identify missing values or to identify values that are outside the lower and upper limits of a variable.
}
\examples{
# Missing values
example <- rd_query(covican,
                    variables = c("copd", "age"),
                    expression = c("\%in\%NA", "\%in\%NA"),
                    event = "baseline_visit_arm_1")
example

# Expression
example <- rd_query(covican,
                    variables="age",
                    expression=">20",
                    event="baseline_visit_arm_1")
example

# Using the filter argument
example <- rd_query(covican,
                    variables = "potassium",
                    expression = "\%in\%NA",
                    event = "baseline_visit_arm_1",
                    filter = "available_analytics=='1'")
example
}
