% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prog.R
\name{MarginalProba}
\alias{MarginalProba}
\title{Bayesian test for anteriority / posteriority between two parameters}
\usage{
MarginalProba(a_chain, b_chain)
}
\arguments{
\item{a_chain}{numeric vector containing the output of the MCMC algorithm for the first one-parameter (date) a  }

\item{b_chain}{numeric vector containing the output of the same MCMC algorithm for the second one-parameter  (date) b}
}
\value{
Returns the posterior probability of the following assumption: "Event a is older than event b"
}
\description{
This function estimates the posterior probability that event 'a' is older than event 'b' using the output of the MCMC algorithm. This provides a bayesian test for checking the following assumption: "Event a is older than event b"
}
\details{
For a given output of MCMC algorithm, this function estimates the  posterior probability of the  event 'a' < 'b'  by the relative frenquency of the event  "the value of event 'a' is lower than the value of event 'b'"  in the simulated Makov chain.}
\author{
Anne Philippe <Anne.Philippe@univ-nantes.fr> and

Marie-Anne Vibet <Marie-Anne.Vibet@univ-nantes.fr>
}
\examples{
  data(Events); attach(Events)

  # Probability that Event.1 is older than Event.12
  MarginalProba(Event.1, Event.12)
  # Probability that Event.1 is older than Event.2
  MarginalProba(Event.1, Event.2)

  # Probability that the beginning of the phase 1 is older than the end of the phase 1
  # Should always be 1 for every phase
  data(Phases); attach(Phases)

  MarginalProba(Phase.1.alpha, Phase.1.beta)

}

\keyword{ Bayesian test}
\keyword{ anteriority / posteriority}


