% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03_IFE_algorithm_functions.R
\name{calculate_error_term}
\alias{calculate_error_term}
\title{Calculates the error term Y - X*beta_est - LF - LgFg.}
\usage{
calculate_error_term(
  Y,
  X,
  beta_est,
  g,
  factor_group,
  lambda_group,
  comfactor,
  lambda,
  S,
  k,
  kg,
  method_estimate_beta = "individual",
  no_common_factorstructure = FALSE,
  no_group_factorstructure = FALSE
)
}
\arguments{
\item{Y}{Y: NxT dataframe with the panel data of interest}

\item{X}{X: NxTxp array containing the observable variables}

\item{beta_est}{estimated values of beta}

\item{g}{Vector with estimated group membership for all individuals}

\item{factor_group}{estimated group specific factors}

\item{lambda_group}{loadings of the estimated group specific factors}

\item{comfactor}{estimated common factors}

\item{lambda}{loadings of the estimated common factors}

\item{S}{number of estimated groups}

\item{k}{number of common factors to be estimated}

\item{kg}{number of group specific factors to be estimated}

\item{method_estimate_beta}{defines how beta is estimated. Default case is an estimated beta for each individual. Default value is "individual." Possible values are "homogeneous", "group" or "individual".}

\item{no_common_factorstructure}{if there is a common factorstructure being estimated}

\item{no_group_factorstructure}{if there is a group factorstructure being estimated}
}
\value{
NxT matrix
}
\description{
Calculates the error term Y - X*beta_est - LF - LgFg.
}
\examples{
X <- X_dgp3
Y <- Y_dgp3
# Set estimations for group factors and its loadings, and group membership
#  to the true value for this example.
lambda_group <- lambda_group_true_dgp3
factor_group <- factor_group_true_dgp3
g <- g_true_dgp3
set.seed(1)
beta_est <- matrix(rnorm(nrow(Y) * 4), ncol = nrow(Y)) #random values for beta
comfactor <- matrix(0, ncol = ncol(Y))
lambda  <- matrix(0, ncol = nrow(Y))
calculate_error_term(Y, X, beta_est, g, factor_group, lambda_group, comfactor, lambda,
  3, 0, c(3, 3, 3))
}
