% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exports.R
\name{GetWeekPredCI}
\alias{GetWeekPredCI}
\title{Calculate median recruitment with 95\% CI for the next 104 weeks (two years)}
\usage{
GetWeekPredCI(
  nSim = 10000L,
  fillGaps = FALSE,
  cauchyWt = FALSE,
  efficiencyFactor = 1
)
}
\arguments{
\item{nSim}{Number of simulations to run (default = 1e4L). Accepted values are in the \if{html}{\out{<br>}}
range of 1 to 10,000.}

\item{fillGaps}{Whether to fill recruitment gaps in the data (default = FALSE).\if{html}{\out{<br>}}
Recruitment gaps are defined as any full week (Monday through Sunday) with\if{html}{\out{<br>}}
no dates recorded in the loaded data. If at least one date is present within\if{html}{\out{<br>}}
a given week, that week will not be considered a gap in recruitment.}

\item{cauchyWt}{Whether to use Cauchy weights for sampling.
If FALSE (default),\if{html}{\out{<br>}}
binomial weights are used.}

\item{efficiencyFactor}{An efficiency coefficient to apply to the recruitment rate (default = 1).\if{html}{\out{<br>}}
If the efficiency of the recruitment process is expected to match\if{html}{\out{<br>}}
the provided data, this value should be set to 1. If the recruitment\if{html}{\out{<br>}}
process is expected to be slower, this value should less than 1. Finally,\if{html}{\out{<br>}}
if the recruitment process is expected to proceed faster, this value should be\if{html}{\out{<br>}}
greater than 1. Accepted values range from 0.1 to 2:\if{html}{\out{<br>}}
\itemize{
\item 0.1: Indicates that the recruitment rate is expected to be 10\% of the original rate.
\item 2.0: Indicates that the recruitment rate is expected to be double the original rate.
}}
}
\value{
An object of \code{RCTPredCI} class with 5 elements.
\enumerate{
\item \code{predCI}: An 104x3 matrix with the 2.5\%, 50\% and 97.5\% weekly percentiles
\item \code{plot(yMax = NULL, Title = NULL)}:\if{html}{\out{<br>}}
Function which plots the results. It accepts the following arguments:
\itemize{
\item \code{yMax} sets the upper limit of the y-axis
\item \code{Title} sets the main title for the plot
}
\item \code{pargs}:\if{html}{\out{<br>}}
An environment which contains objects and functions used to construct\if{html}{\out{<br>}}
the plot. Additional plot configuration to what the \code{plot()} function\if{html}{\out{<br>}}
currently supports, can be achieved by modifying those objects
\item \code{call.}: The call (deparsed) that created the object
\item \code{cargs}: A list with the arguments of the call that created the object\if{html}{\out{<br>}}
including the default arguments
}
}
\description{
Calculate median recruitment with 95\% CI for the next 104 weeks (two years)
}
\examples{
LoadData(gripsYR1, ScreenDt, Enrolled)
(res <- GetWeekPredCI(fillGaps = TRUE, efficiencyFactor = 1.5))
scenarios <- list(
  sc1 = GetWeekPredCI(),
  sc2 = GetWeekPredCI(cauchyWt = TRUE),
  sc3 = GetWeekPredCI(fillGaps = TRUE),
  sc4 = GetWeekPredCI(fillGaps = TRUE, efficiencyFactor = 1.2)
)
maxY <- sapply(scenarios, \(x) x$pargs$maxY) |> max()
defaultGraphicParams <- par(no.readonly = TRUE)
graphics::par(mfrow = c(2, 2), oma = c(0, 1, 0, 7), mar = c(4, 4, 3, 1))
for (x in scenarios) x$plot(yMax = maxY, Title = x$call.)
do.call(par, defaultGraphicParams)
}
\seealso{
Other Links: 
\code{\link{GetDistance}()},
\code{\link{LoadData}()},
\code{\link{RCTRecruit-package}},
\code{\link{Time2Nsubjects}()},
\code{\link{gripsYR1}},
\code{\link{gripsYR2}},
\code{\link{gripsYR2Weekly}}
}
\concept{Links}
