% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/balance_table.R
\name{balance_table}
\alias{balance_table}
\title{Creates balance table for the X variables across treatment status}
\usage{
balance_table(data, treatment)
}
\arguments{
\item{data}{A data.frame, tibble or data.table}

\item{treatment}{a string with treatment status column}
}
\value{
A tibble with Mean_value of each treatment status and p_values
}
\description{
Creates balance table for the X variables across treatment status
}
\details{
balance_table() performs t.test(X~treatment) for each X column in data. Every value of 
treatment i.e 1,2,3,...N is compared against control value (0) or the first value of the treatment
column. For instance, If treatment column has values of (0,1,2,3), balance_table will return: 
the mean value of each treatment (for all X's), and the p_values of the t.test of (1,2,3) against
treatment = 0.
}
\examples{
data <-data.frame(x1 = rnorm(n = 100, mean = 100, sd = 15), 
                  x2=rnorm(n = 100, mean = 65), 
                  treatment = rep(c(0,1,2,3,4), each = 20))
balance_table(data, "treatment")
}
