\name{RC.reproduce}
\alias{RC.reproduce}
\title{
Reproduce a computation
}
\description{
This function fetches the meta data of a computation and reproduces the analysis on your local machine.
}
\usage{
RC.reproduce(url = "", echo = FALSE, secure = TRUE)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{url}{
The unique URL of the computation to be reproduced
}
  \item{echo}{
Print intermediary results to screen
}
  \item{secure}{
Check R code against blacklist of potentially dangerous commands
}
}
%%\details{
%%  ~~ If necessary, more details than the description above ~~
%%}
\value{
The object 'a' contains the HTML output of any reproduced computation that was originally generated by an R module (as published on the web). To display the information in the R console it is appropriate to use the RC.print.html(a) command.
The reproduced computation may create or change objects in the R session (see RC.demo() for an example).
%%  ~Describe the value returned
%%  If it is a LIST, use
%%  \item{comp1 }{Description of 'comp1'}
%%  \item{comp2 }{Description of 'comp2'}
%% ...
}

%% ~Make other sections like Warning with \section{Warning }{....} ~
\section{Warning}{This function executes R code in your current R session. This implies that objects may be overwritten or changed as a result of using RC.reproduce().}

\examples{
#[not run]
#fetch info about the computations with the 'AS2009' keyword
#r <- RC.ls(keyword="AS2009")
#reproduce the second computation
#RC.reproduce(r$url[2])
#print the output table
#RC.print.html(a)
}
\keyword{ IO }
\keyword{ connection }
\keyword{ database }
