% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RBF-fn.R
\name{plot.backf}
\alias{plot.backf}
\title{Diagnostic plots for objects of class \code{backf}}
\usage{
\method{plot}{backf}(x, ask = FALSE, which = 1:np, ...)
}
\arguments{
\item{x}{an object of class \code{backf}, a result of a call to \code{\link{backf.cl}} or \code{\link{backf.rob}}.}

\item{ask}{logical value. If \code{TRUE}, the graphical device will prompt for confirmation before
going to the next page/screen of output.}

\item{which}{vector of indices of explanatory variables for which partial residuals plots will
be generaetd. Defaults to all available explanatory variables.}

\item{...}{additional other arguments. Currently ignored.}
}
\description{
Plot method for objects of class \code{backf}.
}
\examples{
data(airquality)
x <- airquality
x <- x[complete.cases(x), c('Ozone', 'Solar.R', 'Wind', 'Temp')]
y <- as.vector(x$Ozone)
x <- as.matrix(x[, c('Solar.R', 'Wind', 'Temp')])
tmp <- backf.rob(Xp = x, yp=y, windows=c(136.7, 8.9, 4.8) , degree=1)
plot(tmp, which=1:2)

}
\author{
Alejandra Mercedes Martinez \email{ale_m_martinez@hotmail.com}
}
