% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RBF-fn.R
\name{backf.rob.cv}
\alias{backf.rob.cv}
\title{Cross-validation for Robust Backfitting}
\usage{
backf.rob.cv(k = 5, Xp, yp, windows, epsilon = 1e-06, degree,
  type = "Tukey", k.h = 1.345, k.t = 4.685, seed = 123,
  max.it = 50)
}
\arguments{
\item{k}{a positive integer indicating the number of folds.}

\item{Xp}{a matrix (n x p) containing the explanatory variables}

\item{yp}{vector of responses (missing values are allowed)}

\item{windows}{vector of bandwidths for the local polynomial smoother,
one per explanatory variable.}

\item{epsilon}{convergence criterion. Maximum allowed relative difference between
consecutive estimates}

\item{degree}{degree of the local polynomial smoother. Defaults to \code{0} (local constant).}

\item{type}{one of either \code{'Tukey'} or \code{'Huber'}.}

\item{k.h}{tuning constant for a Huber-type loss function.}

\item{k.t}{tuning constant for a Tukey-type loss function.}

\item{seed}{an integer used to set the seed of the pseudo-number generator that
creates the \code{k} folds.}

\item{max.it}{Maximum number of iterations for the algorithm.}
}
\value{
A real number with a robust measure of (hold-out) prediction error
}
\description{
This function performs one run of K-fold cross-validation using the
robust backfitting algorithm.
}
\details{
This function performs one run of K-fold cross-validation using the
robust backfitting algorithm and returns a robust measure of the
hold out prediction error.
}
\examples{
data(airquality)
x <- airquality
x <- x[complete.cases(x), c('Ozone', 'Solar.R', 'Wind', 'Temp')]
y <- as.vector(x$Ozone)
x <- as.matrix(x[, c('Solar.R', 'Wind', 'Temp')])
backf.rob.cv(k=5, Xp = x, yp=y, windows=c(136.7, 8.9, 4.8), type='Tukey', degree=1)

}
\author{
Matias Salibian-Barrera, \email{matias@stat.ubc.ca}, Alejandra Martinez
}
