% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bystate.R
\name{aqs_transactionsample_by_state}
\alias{aqs_transactionsample_by_state}
\title{aqs_transactionsample_by_state}
\usage{
aqs_transactionsample_by_state(
  parameter,
  bdate,
  edate,
  stateFIPS,
  return_header = FALSE
)
}
\arguments{
\item{parameter}{a character list or a single character string
which represents the parameter code of the air
pollutant related to the data being requested.}

\item{bdate}{a R date object which represents that begin date of the data
selection. Only data on or after this date will be returned.}

\item{edate}{a R date object which represents that end date of the data
selection. Only data on or before this date will be returned.}

\item{stateFIPS}{a R character object which represents the 2 digit state
FIPS code (with leading zero) for the state being
requested. @seealso \code{\link[=aqs_states]{aqs_states()}} for the list of
available FIPS codes.}

\item{return_header}{If FALSE (default) only returns data requested.
If TRUE returns a AQSAPI_v2 object which is a two
item list that contains header information returned
from the API server mostly used for debugging
purposes in addition to the data requested.}
}
\value{
a tibble or an AQS_Data Mart_APIv2 S3 object of transaction sample
(raw) data in the AQS submission transaction format (RD)
corresponding to the inputs provided.
}
\description{
\lifecycle{stable}
Returns transactionsample data - aggregated by state
in the AQS Submission Transaction Format (RD) sample (raw) data for
a parameter code aggregated by matching input parameter, and
stateFIPS provided for bdate - edate time frame. Includes data both
in submitted and standard units
}
\note{
The AQS API only allows for a single year of transactiondata to be
retrieved at a time. This function conveniently extracts date
information from the bdate and edate parameters then makes repeated
calls to the AQSAPI retrieving a maximum of one calendar year of
data at a time. Each calendar year of data requires a separate API
call so multiple years of data will require multiple API calls.
As the number of years of data being requested increases so does the
length of time that it will take to retrieve results. There is also a
5 second wait time inserted between successive API calls to prevent
overloading the API server. This operation has a linear run time of
/(Big O notation: O/(n + 5 seconds/)/).
}
\examples{
#Returns a AQS_Data Mart_APIv2 S3 object of
         \dontrun{ #   all benzene transaction sample data for
                   #   North Carolina on May 15, 1995
                   aqs_transactionsample_by_state(parameter = "45201",
                                                 bdate = as.Date("19950515",
                                                         format = "\%Y\%m\%d"),
                                                 edate = as.Date("19950515",
                                                          format = "\%Y\%m\%d"),
                                                 stateFIPS = "37"
                                                 )
                 }
}
\seealso{
Other Aggregate _by_state functions: 
\code{\link{aqs_transactionsample_by_MA}()}
}
\concept{Aggregate _by_state functions}
