% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run.studies.R
\name{run.studies}
\alias{run.studies}
\title{This function runs the case studies included in the package}
\usage{
run.studies(
  TS,
  study,
  TSextra,
  With.p.value = FALSE,
  BasicComparison = TRUE,
  nsample = 500,
  alpha = 0.05,
  param_alt,
  maxProcessor,
  B = 1000
)
}
\arguments{
\item{TS}{routine to calculate test statistics.}

\item{study}{either the name of the study, or its number. If missing all the studies are run.}

\item{TSextra}{list passed to TS.}

\item{With.p.value}{=FALSE does user supplied routine return p values?}

\item{BasicComparison}{=TRUE if true compares tests on one default value of parameter of the alternative distribution.}

\item{nsample}{= 500, desired sample size.}

\item{alpha}{=0.05  type I error}

\item{param_alt}{(list of) values of parameter under the alternative hypothesis. If missing included values are used.}

\item{maxProcessor}{number of cores to use for parallel programming}

\item{B}{= 1000}
}
\value{
A (list of ) matrices of p.values
}
\description{
This function runs the case studies included in the package
}
\examples{
#The new test is a simple chisquare test:
chitest = function(x, y, TSextra) {
   nbins=TSextra$nbins
   nx=length(x);ny=length(y);n=nx+ny
   xy=c(x,y)
   bins=quantile(xy, (0:nbins)/nbins)
   Ox=hist(x, bins, plot=FALSE)$counts
   Oy=hist(y, bins, plot=FALSE)$counts
   tmp=sqrt(sum(Ox)/sum(Oy))
   chi = sum((Ox/tmp-Oy*tmp)^2/(Ox+Oy))
   pval=1-pchisq(chi, nbins-1)
   out=ifelse(TSextra$statistic,chi,pval)
   names(out)="ChiSquare"
   out
}
TSextra=list(nbins=5,statistic=FALSE) # Use 5 bins and calculate p values
run.studies(chitest,TSextra=TSextra, With.p.value=TRUE, B=100)
}
