\name{integrity.checks}
\alias{integrity.checks}
\title{Input parameters integrity checks}
\description{Input parameters integrity checks}
\usage{integrity.checks(epid, t, GT, begin, end, date.first.obs, time.step, 
    AR, S0, methods)}
\arguments{
  \item{epid}{Name of epidemic dataset}
  \item{t}{Date vector}
  \item{GT}{Generation Time repartition function}
  \item{begin}{Begin date for estimation. Can be an integer or a date (YYYY-mm-dd or YYYY/mm/dd)}
  \item{end}{End date for estimation. Can be an integer or a date (YYYY-mm-dd or YYYY/mm/dd)}
  \item{date.first.obs}{Optional date of first observation, if t not specified}
  \item{time.step}{Optional. If date of first observation is specified, number of day between each incidence observation}
  \item{AR}{Attack rate as a percentage from total population}
  \item{S0}{Initial proportion of the population considered susceptible}
  \item{methods}{List of methods to be used for R0 estimation/comparison. Must be provided as c("method 1", "method 2", ...)}
}
\details{For internal use.

All integrity/class checks are handled by this core function. GT must be an object of class R0.GT, 
and epidemic curve along with time values are handled here. If you plan on calling manually any other
estimation function, make sure data are provided with correct format.

The epidemic curve 'epid' may be provided as a vector. 
In that case, a vector t may be provided with the dates of observation. 
If t is not numeric, an attempt is made to convert to dates with as.Date. 
If t is not provided, dates are obtained from the names of incid, and inf not available, index values are used. 
Finally, one can provide an epidemic curve object generated by the Epitools package (see check.incid for details).

A quick note on 't', 'begin' and 'end' :
When a date vector is provided (t), it will be used instead of index values to establish a date-related incidence.
If no date vector is provided, then 'begin' and 'end' can still be forced to NUMERIC values. It then links to the corresponding index values for incidence data.
If a date vector is provided, 'begin' and 'end' can either be NUMERIC values or DATES. If numeric, they will link to the correspondig index values for incidence, and afterward interpreted as the associated date. If date, they will be directly associated to incidence data.
Basicly, if specified, 'begin' and 'end' must always have the same class.}


\author{Pierre-Yves Boelle, Thomas Obadia}






\keyword{internal}
