% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CompareQuartets.R
\name{QuartetState}
\alias{QuartetState}
\alias{QuartetStates}
\alias{QuartetStates.Splits}
\alias{QuartetStates.list}
\alias{QuartetStates.multiPhylo}
\title{Quartet State(s)}
\usage{
QuartetState(tips, bips, splits = bips, asRaw = FALSE)

QuartetStates(splits, asRaw = FALSE)

\method{QuartetStates}{Splits}(splits, asRaw = FALSE)

\method{QuartetStates}{list}(splits, asRaw = FALSE)

\method{QuartetStates}{multiPhylo}(splits, asRaw = FALSE)
}
\arguments{
\item{tips}{A four-element array listing a quartet of leaves, either by their
number (if class \code{numeric}) or their name (if class \code{character}).}

\item{bips}{Depreciated; included for compatibility with v1.0.2 and below.}

\item{splits}{An object that can be induced to a \code{Splits} object using
\code{\link[TreeTools]{as.Splits}}.}

\item{asRaw}{Logical specifying whether return format should be \code{raw},
which uses less memory and can be processed faster than \code{integer} type.
Default is currently set to \code{FALSE} for backwards compatibility; suggest
overriding to \code{TRUE}.}
}
\value{
\code{QuartetState()} returns \code{0} if the relationships of the four leaves
are not constrained by the provided splits, or the index of the closest
relative to \code{tips[4]}, otherwise.

\code{QuartetStates()} returns a raw vector listing the status of each
quartet of leaves (in the order listed by \code{\link[=AllQuartets]{AllQuartets()}}) in turn,
or if multiple trees are provided, a matrix in which each row corresponds
to such a vector.
}
\description{
Report the status of the specified quartet(s) in given trees or lists of
splits.
}
\details{
One of the three possible four-leaf trees will be consistent with any set of
splits generated from a fully resolved tree.  If the leaves are numbered
1 to 4, this tree can be identified by naming the leaf most closely related
to leaf 4.
If a set of splits is generated from a tree that contains polytomies,
it is possible that all three four-leaf trees are consistent with the set
of splits.
}
\examples{
trees <- list(TreeTools::BalancedTree(6),
              TreeTools::PectinateTree(6))

trees[[3]] <- TreeTools::CollapseNode(trees[[2]], 9:10)

QuartetState(c(1, 3, 4, 6), trees[[2]])  
QuartetState(1:4, trees[[1]]) == QuartetState(1:4, trees[[2]])
QuartetState(c(1, 3, 4, 6), trees[[3]])  

QuartetStates(trees[[2]])
QuartetStates(trees[[3]])

CompareQuartets(QuartetStates(trees[[2]]), QuartetStates(trees[[3]]))
CompareQuartetsMulti(trees[[1]], trees[2:3])

}
\references{
\itemize{
\item \insertRef{Estabrook1985}{Quartet}
}
}
\seealso{
Compare quartet states between trees (slowly) using
\code{\link[=CompareQuartets]{CompareQuartets()}} and \code{\link[=CompareQuartetsMulti]{CompareQuartetsMulti()}}.

Other element-by-element comparisons: 
\code{\link{CompareQuartetsMulti}()},
\code{\link{CompareQuartets}()},
\code{\link{CompareSplits}()},
\code{\link{PairSharedQuartetStatus}()},
\code{\link{SharedQuartetStatus}()},
\code{\link{SplitStatus}()}
}
\author{
\href{https://orcid.org/0000-0001-5660-1727}{Martin R. Smith}
(\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
\concept{element-by-element comparisons}
