% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QuartetDistance.R
\name{PairSharedQuartetStatus}
\alias{PairSharedQuartetStatus}
\title{Status of quartets that exist in two trees}
\usage{
PairSharedQuartetStatus(tree1, tree2)
}
\arguments{
\item{tree1, tree2}{Trees of class \code{\link[ape:read.tree]{phylo}}
to compare.}
}
\value{
Returns a named array of six integers corresponding to the quantities of Estabrook \emph{et al}. (1985):
\describe{
\item{N}{The total number of quartet \emph{statements} for two trees of \emph{n} tips,
i.e. 2 \emph{Q}.}
\item{Q}{The total number of quartets for \emph{n} tips.}
\item{s}{The number of quartets that are resolved identically in both trees.}
\item{d}{The number of quartets that are resolved differently in each tree.}
\item{r1}{The number of quartets that are resolved in tree 1, but not in tree 2.}
\item{r2}{The number of quartets that are resolved in tree 2, but not in tree 1.}
\item{u}{The number of quartets that are unresolved in both trees.}
}
}
\description{
Removes all tips that do not occur in both \code{tree1} and \code{tree2}, then calculates
the status of the remaining quartets.
}
\seealso{
Other element-by-element comparisons: \code{\link{CompareQuartets}},
  \code{\link{CompareSplits}}, \code{\link{QuartetState}},
  \code{\link{SharedQuartetStatus}},
  \code{\link{SplitStatus}}
}
\author{
\href{https://orcid.org/0000-0001-5660-1727}{Martin R. Smith}
(\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
\concept{element-by-element comparisons}
\keyword{internal}
