% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doc_RollVolumeProfile.R
\name{RollVolumeProfile}
\alias{RollVolumeProfile}
\title{C++ Rolling Volume Profile class}
\arguments{
\item{timeFrame}{indicator period in seconds, when to apply alpha correction}

\item{step}{price round off value, bar width}

\item{alpha}{multiplication coefficient must be between (0,1]}

\item{cut}{threshold volume when to delete bar}
}
\description{
C++ class documentation
}
\details{
R functions \link{roll_volume_profile}.
}
\section{Usage}{
 \code{RollVolumeProfile( int timeFrame, double step, double alpha, double cut )}
}

\section{Public Members and Methods}{

\tabular{lll}{
\strong{Name}                 \tab \strong{Return Type}          \tab \strong{Description}                                \cr
\code{Add( \link{Tick} tick )}\tab \code{void}                   \tab update indicator                                    \cr
\code{Reset()}                \tab \code{void}                   \tab reset to initial state                              \cr
\code{IsFormed()}             \tab \code{bool}                   \tab is indicator value valid?                           \cr
\code{GetValue()}             \tab \code{std::map<double,double>}\tab histogram where first is price and second is volume \cr
\code{GetHistory()}           \tab \code{List}                   \tab return values history data.table with columns \code{time, profile} where profile is data.table with columns \code{time, price, volume}
}
}

\seealso{
Other C++ indicators: \code{\link{BBands}},
  \code{\link{Crossover}}, \code{\link{Ema}},
  \code{\link{Indicator}}, \code{\link{RollLinReg}},
  \code{\link{RollPercentRank}}, \code{\link{RollRange}},
  \code{\link{RollSd}}, \code{\link{Rsi}},
  \code{\link{Sma}}, \code{\link{Stochastic}}

Other C++ classes: \code{\link{BBands}},
  \code{\link{Candle}}, \code{\link{Cost}},
  \code{\link{Crossover}}, \code{\link{Ema}},
  \code{\link{Indicator}}, \code{\link{Order}},
  \code{\link{Processor}}, \code{\link{RollLinReg}},
  \code{\link{RollPercentRank}}, \code{\link{RollRange}},
  \code{\link{RollSd}}, \code{\link{Rsi}},
  \code{\link{Sma}}, \code{\link{Stochastic}},
  \code{\link{Tick}}
}
