% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering_functions.R
\name{stats_clusters}
\alias{stats_clusters}
\alias{stats_clusters,pkbc-method}
\title{Descriptive statistics for the clusters identified by the Poisson
kernel-based clustering.}
\usage{
stats_clusters(object, ...)

\S4method{stats_clusters}{pkbc}(object, k)
}
\arguments{
\item{object}{Object of class \code{pkbc}.}

\item{...}{possible additional inputs}

\item{k}{Number of clusters to be used.}
}
\value{
List with computed descriptive statistics for each variable.
}
\description{
Method for objects of class \code{pkbc} which computes some
descriptive for each variable with respect to the detected groups.

Method for objects of class \code{pkbc} which computes some
descriptive for each variable with respect to the detected groups.
}
\details{
The function computes mean, standard deviation, median,
inter-quantile range, minimum and maximum for each variable in the data set
given the final membership assigned by the clustering algorithm.
}
\examples{
#We generate three samples of 100 observations from 3-dimensional
#Poisson kernel-based densities with rho=0.8 and different mean directions
dat<-matrix(rnorm(300),ncol=3)

#Perform the clustering algorithm
pkbc_res<- pkbc(dat, 3)
stats_clusters(pkbc_res, 3)


}
