augmentedZagreb <- function(g, deg=NULL){
  require("graph")

  if (class(g)[1] != "graphNEL")
    stop("'g' must be a 'graphNEL' object")

  if (is.null(deg))
    deg <- graph::degree(g)

  sum(.edgeApply(g, function(from, to) {
    ((deg[from] * deg[to]) / (deg[from] + deg[to] - 2)) ^ 3
  }, dupls=FALSE))
}
