% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QPBoot-class.R
\docType{methods}
\name{plot-QPBoot}
\alias{plot-QPBoot}
\alias{plot,QPBoot,ANY-method}
\title{Plot the values of a \code{\link{QPBoot}}.}
\usage{
\S4method{plot}{QPBoot,ANY}(x, ptw.CIs = 0.1, method = "quantiles",
  ratio = 3/2, widthlab = lcm(1), xlab = expression(omega/2 * pi),
  ylab = NULL, type.scaling = c("individual", "real-imaginary", "all"),
  frequencies = x@sPG@frequencies, levels = intersect(x@sPG@levels[[1]],
  x@sPG@levels[[2]]))
}
\arguments{
\item{x}{The \code{\link{SmoothedPG}} object to plot}

\item{ptw.CIs}{the confidence level for the conspec = garchSpec(model = param)fidence intervals to be
displayed; must be a number from [0,1]; if null, then no
confidence intervals will be plotted.}

\item{method}{either "quantile" or "norm", determines how the confidence intervalls are calculated.
see description for details}

\item{ratio}{quotient of width over height of the subplots; use this
parameter to produce landscape or portrait shaped plots.}

\item{widthlab}{width for the labels (left and bottom); default is
\code{lcm(1)}, cf. \code{\link[graphics]{layout}}.}

\item{xlab}{label that will be shown on the bottom of the plots; can be
an expression (for formulas), characters or \code{NULL} to
force omission (to save space).}

\item{ylab}{label that will be shown on the left side of the plots;
can be an expression (for formulas), characters or
\code{NULL} to force omission (to save space).}

\item{type.scaling}{a method for scaling of the subplots; currently there
are three options: \code{"individual"} will scale each of the
\code{K^2} subplots to minimum and maximum of the values
in that plot, \code{"real-imaginary"} will scale each of the
subplots displaying real parts and each of the subplots
displaying imaginary parts to the minimum and maximum of
the values display in these subportion of plots. The
option \code{"all"} will scale the subplots to the minimum and
maximum in all of the subplots.}

\item{frequencies}{a set of frequencies for which the values are to be
plotted.}

\item{levels}{a set of levels for which the values are to be plotted.}
}
\value{
Returns the plot described in the Description section.
}
\description{
Creates a \code{K} x \code{K} plot depicting a smoothed quantile periodogram.
Optionally pointwise confidence intervals from the parametric bootstrap can
be displayed.
In each of the subplots either the real part (on and below the diagonal;
i. e., \eqn{\tau_1 \leq \tau_2}{tau1 <= tau2}) or the imaginary parts
(above the diagonal; i. e., \eqn{\tau_1 > \tau_2}{tau1 > tau2}) of
\describe{
  \item{}{the smoothed quantile periodogram (blue line)}
  \item{}{pointwise confidence intervals from the parametric bootstrap (light gray area)}
}
for the combination of levels \eqn{\tau_1}{tau1} and \eqn{\tau_2}{tau2}
denoted on the left and bottom margin of the plot are displayed.
The \code{method} argument determines how the confidence intervalls are calculated.
 \describe{
  \item{quantile}{calculates the (1-\eqn{\alpha/2}) and \eqn{\alpha/2} quantiles from the bootstrap} 
  \item{norm}{asymptotic normality of the smoothed Periodograms is used, mean and standard deviation are
                estimated from the bootstrap}
}
}
