% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/All_Rep_Code.R
\name{two.factor.rep}
\alias{two.factor.rep}
\title{Measure of (unadjusted) repeatability}
\usage{
two.factor.rep(dataset, gamma = 1)
}
\arguments{
\item{dataset}{data frame of diet estimates. Columns 1 and 2 of
\code{dataset} must be the first and second factors in your two factor
ANOVA model where column 1 specifies the predator and column 2 the
year, season, etc...}

\item{gamma}{needed to compute CS distance.  Default is 1.}
}
\value{
unadjusted consistent repeatability, unadjusted absolute repeatability
        and the number of levels of second factor (eg. year, seasons, etc..)
}
\description{
Measure of (unadjusted) repeatability
}
\details{
We use absolute repeatability (or intraclass correlation coefficient).
         The difference in the two types is discussed in:
         McGraw and Wong (1996) Forming Inferences about some intraclass
         correlation coefficients.  Psychological Methods. 1(1):30-46.
}
\keyword{internal}
