% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qfasa.R
\name{p.QFASA}
\alias{p.QFASA}
\title{Computes the diet estimate for each predator in seal.mat using
either the Kullback-Leibler Distance (KL), the Aitchison Distance
(AIT) or the Chi-Squared Distance (CS).}
\usage{
p.QFASA(seal.mat, prey.mat, cal.mat, dist.meas, gamma, FC = rep(1,
  nrow(prey.mat)), start.val = rep(0.99999, nrow(prey.mat)), ext.fa)
}
\arguments{
\item{seal.mat}{matrix containing the FA signatures of the predator}

\item{prey.mat}{matrix containing a representative FA signature
from each prey group (usually the mean) -> assumes that the
first column contains the name of the prey group}

\item{cal.mat}{matrix of calibration factors where the *i* th
column is to be used with the *i* th seal}

\item{dist.meas}{distance measure to use for estimation: 1=KL,
2=AIT or 3=CS}

\item{gamma}{parameter required for calculations using CS distance
(passed to CS.obj). Currently being set to =1.}

\item{FC}{TODO}

\item{start.val}{TODO}

\item{ext.fa}{TODO}
}
\description{
Computes the diet estimate for each predator in seal.mat using
either the Kullback-Leibler Distance (KL), the Aitchison Distance
(AIT) or the Chi-Squared Distance (CS).
}
\examples{
# predators
predators.n <- 10
fa.n <- 3
predators <- gtools::rdirichlet(predators.n, alpha=rep(1, fa.n))*100

# prey
prey.n <- 4
prey <- gtools::rdirichlet(prey.n, alpha=rep(1, fa.n))

# calibration coefficients
cal <- matrix(rep(gtools::rdirichlet(1, alpha=rep(1, fa.n)), predators.n), fa.n, predators.n)
# Run QFASA
QFASA::p.QFASA(predators, prey, cal, dist.meas = 1)

}

