% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-nmfi.R
\name{get_nmfi}
\alias{get_nmfi}
\title{Calculate normalised MFI values for a plate}
\usage{
get_nmfi(
  plate,
  reference_dilution = 1/400,
  data_type = "Median",
  verbose = TRUE
)
}
\arguments{
\item{plate}{(\code{Plate()}) a plate object for which to calculate the nMFI values}

\item{reference_dilution}{(\verb{numeric(1) or character(1)}) the dilution value of the standard curve sample
to use as a reference for normalisation. The default is \code{1/400}.
It should refer to a dilution of a standard curve sample in the given plate object.
This parameter could be either a numeric value or a string.
In case it is a character string, it should have format \verb{1/d+}, where \verb{d+} is any positive integer.}

\item{data_type}{(\code{character(1)}) type of data for the computation. Median is the default}

\item{verbose}{(\code{logical(1)}) print additional information. The default is \code{TRUE}}
}
\value{
nmfi (\code{data.frame}) a data frame with normalised MFI values for each analyte in the plate and all test samples.
}
\description{
The function calculates the normalised MFI (nMFI) values for each of the analytes in the plate.

The nMFI values are calculated as the ratio of the test samples' MFI values to the standard curve samples with the target dilution.

\strong{When nMFI could be used?}
In general, it is preferred to use Relative Antibody Unit (RAU) values for any analysis.
However, it is sometimes impossible to fit a model to the standard curve samples.
This may happen if the MFI values of test samples are much higher than the MFI of standard curve samples.
Then, the prediction would require significant data extrapolation, which could lead to unreliable results.

In such cases, the nMFI values could be used as a proxy for RAU values if we want, for instance, to account for plate-to-plate variation.
}
\examples{

# read the plate
plate_file <- system.file("extdata", "CovidOISExPONTENT.csv", package = "PvSTATEM")
layout_file <- system.file("extdata", "CovidOISExPONTENT_layout.csv", package = "PvSTATEM")

plate <- read_luminex_data(plate_file, layout_file)

# artificially bump up the MFI values of the test samples (the Median data type is default one)
plate$data[["Median"]][plate$sample_types == "TEST", ] <-
  plate$data[["Median"]][plate$sample_types == "TEST", ] * 10

# calculate the nMFI values
nmfi <- get_nmfi(plate, reference_dilution = 1 / 400)

# we don't do any extrapolation and the values should be comparable across plates
head(nmfi)
# different params
nmfi <- get_nmfi(plate, reference_dilution = "1/50")

}
