% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subset_data.R
\name{create_window_data}
\alias{create_window_data}
\title{Make PupillometryR dataframe into a single collapsed window for easy analysis}
\usage{
create_window_data(data, pupil)
}
\arguments{
\item{data}{a PupillometryR dataframe}

\item{pupil}{column name denoting pupil data to be used}
}
\value{
a Pupil_window_data dataframe
}
\description{
This function creates a single collapsed data frame for easy analysis with a t-test or anova,
per condition.
By comparison create_time_windows allows dividing it into multiple windows per time.
}
\examples{
Sdata <- make_pupillometryr_data(data = pupil_data,
                               subject = ID,
                               trial = Trial,
                               time = Time,
                               condition = Type)
regressed_data <- regress_data(data = Sdata, pupil1 = RPupil, pupil2 = LPupil)
mean_data <- calculate_mean_pupil_size(data = regressed_data,
pupil1 = RPupil, pupil2 = LPupil)
base_data <- baseline_data(data = mean_data, pupil = mean_pupil, start = 0, stop = 100)
window <- create_window_data(data = base_data, pupil = mean_pupil)
p <- plot(window, pupil = mean_pupil, windows = FALSE, geom = 'boxplot')
p
}
