% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{check_baseline}
\alias{check_baseline}
\title{Check baseline window for missing data}
\usage{
check_baseline(data = data, BaselineWindow = NULL,
  ReturnData = FALSE)
}
\arguments{
\item{data}{A data table object output by \code{\link{create_time_series}}.}

\item{BaselineWindow}{A numeric vector of length 1 or 2 specifying the time
points of the baseline window to be examined. Providing two values indicates
the start time and the end time of the baseline, respectively. Providing a single value
(i.e., time point) assumes that every preceding time point is part of the
baseline (N.B. trials may vary in the size of the baseline window and will
result in an error).}

\item{ReturnData}{A logical indicating whether to return a data table
containing information for each event.}
}
\value{
Summary information
}
\description{
\code{check_baseline} examines the data in a specified baseline window.
}
\examples{
# Load example data
data("Pupilex3")

check_baseline(Pupilex3, BaselineWindow = c(-500, 0))

# Please see the vignettes for detailed example usage.
# vignette("PupilPre_Basic_Preprocessing", package="PupilPre")

}
