% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create.project.R
\name{.create.project.existing}
\alias{.create.project.existing}
\alias{.create.project.new}
\title{Create a project structure}
\usage{
.create.project.existing(project.name, merge.strategy, template,
  rstudio.project)

.create.project.new(project.name, template, rstudio.project)
}
\arguments{
\item{project.name}{Character vector with the name of the project directory}

\item{merge.strategy}{Character vector determining whether the directory
should be empty or is allowed to contain non-conflicting files}

\item{template}{Name of the template from which the project should be created}

\item{rstudio.project}{Logical indicating whether an \code{.Rproj} file
should be created}
}
\value{
No value is returned; this function is called for its side effects.
}
\description{
\code{.create.project.existing} creates a project directory structure inside
an existing directory with the default files from a given template.

\code{.create.project.new} first creates a new directory and then passes
further control to \code{.create.project.existing}. In case the project
creation fails, the newly created directory is cleaned up.
}
\seealso{
\code{\link{create.project}}, \code{\link{create.template}}
}
\keyword{internal}
