context('Testing Autogeneration')

test_that('stub.tests', {

  test_project <- tempfile('test_project')
  suppressMessages(create.project(test_project))
  on.exit(unlink(test_project, recursive = TRUE), add = TRUE)

  oldwd <- setwd(test_project)
  on.exit(setwd(oldwd), add = TRUE)

  suppressMessages(stub.tests())

  expect_true(file.exists(file.path('tests', 'autogenerated.R')))
  test.code <- scan(file.path('tests', 'autogenerated.R'), what = 'character', sep = '\n', quiet = TRUE)
  expect_that(test.code, equals("expect_that(helper.function(), equals(NULL))"))

})
