% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function_last_time.R
\name{last.time}
\alias{last.time}
\title{Last time for a deterministic projects}
\usage{
last.time(precedence, duration, early.times)
}
\arguments{
\item{precedence}{A matrix that indicates the order of precedence between activities.  If the value \eqn{(i,j)} is equal to 1 then \eqn{i} precedes \eqn{j}.}

\item{duration}{Vector with the duración for each activity.}

\item{early.times}{Vector whit the early times for each activities.}
}
\value{
Last time vector.
}
\description{
This function calculates the last time for one project.
}
\examples{
precedence<-matrix(c(0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0),nrow=5,ncol=5,byrow=TRUE)
duration<-c(3,2,1,1.5,4.2)
early.times<-c(0,0,3.5,2,0)
last.time(precedence,duration,early.times)
}
\references{
\describe{
  \item{}{Burke, R. (2013). Project management: planning and control techniques. New Jersey, USA.}
}
}
