% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/procuste.R
\name{protate}
\alias{protate}
\title{Rotate the \code{src} matrix to fit into the space of the \code{dest} matrix.}
\usage{
protate(src, dest)
}
\arguments{
\item{src}{a numeric matrix to be rotated}

\item{dest}{a numeric matrix used as reference space}
}
\value{
a numeric matrix
}
\description{
The optimal rotation is computed according to the procruste methode.
Rotation is based on singular value decomposition (SVD).
No scaling and no centrering are done, before computing the SVD.
}
\examples{
# Generates two random matrices of size 10 x 15
m1 <- simulate_matrix(10, 15)
m2 <- simulate_matrix(10, 20)

# Rotates matrix m1 on m2
mr <- protate(m1, m2)

}
\author{
Christelle Gonindard-Melodelima

Eric Coissac
}
