% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multivariate.R
\name{is_euclid}
\alias{is_euclid}
\title{Test if the distance matrix is euclidean.}
\usage{
is_euclid(distances, tol = 1e-07)
}
\arguments{
\item{distances}{an object of class 'dist'}

\item{tol}{a tolerance threshold : an eigenvalue is
considered positive if it is larger than
-tol*lambda1 where lambda1 is the largest eigenvalue.}
}
\description{
Actually a simplified version of the ADE4 implementation
(\code{\link[ade4]{is.euclid}}).
}
\examples{
library(vegan)
data(bacteria)

bacteria_rel_freq <- sweep(bacteria,
                           1,
                           rowSums(bacteria),
                           "/")

bacteria_bray <- vegdist(bacteria_rel_freq,method = "bray")
is_euclid(bacteria_bray)

bacteria_chao <- vegdist(floor(bacteria*10000),method = "chao")
is_euclid(bacteria_chao)

}
\author{
Eric Coissac

Christelle Gonindard-Melodelima
}
