% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seq_generator.R
\name{seq_gen2}
\alias{seq_gen2}
\title{Markov action sequence generator}
\usage{
seq_gen2(n, Pmat = NULL, events = letters, start_index = 1,
  end_index = length(events), max_len = 200, include_time = FALSE,
  time_intv_dist = list("exp", 1), seed = 12345)
}
\arguments{
\item{n}{An integer. The number of action sequences to be generated.}

\item{Pmat}{An \code{N} by \code{N} probability transition matrix.}

\item{events}{A character vector specifying the set of \code{N} possible
actions. Default is \code{letters}.}

\item{start_index}{Index of the action indicating the start of an item in
\code{events}.}

\item{end_index}{Index of the action indicating the end of an item in
\code{events}.}

\item{max_len}{Maximum length of generated sequences.}

\item{include_time}{logical. Indicate if timestamp sequences should be generated. Default is
FALSE.}

\item{time_intv_dist}{A list specifying the distribution of the inter-arrival time.}

\item{seed}{random generator seed.}
}
\value{
An object of class \code{"\link{proc}"} with \code{time_seqs = NULL}.
}
\description{
\code{seq_gen2} generates action sequences according to a given probability
transition matrix.
}
\details{
This function generates \code{n} action sequences according \code{Pmat}. The
set of possible actions is \code{events}. All generated sequences start with
\code{events[start_index]} and end with \code{events[end_index]}. If
\code{Pmat} is not supplied, actions is uniformly drawn from
\code{events[-start_index]} until \code{events[end_index]} appears.
}
\seealso{
Other sequence generators: \code{\link{seq_gen3}},
  \code{\link{seq_gen}}
}
\concept{sequence generators}
