% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ProbitSpatial_R.R
\name{generate_W}
\alias{generate_W}
\title{Generate a random spatial weight matrix.}
\usage{
generate_W(n, nneigh, seed=123)
}
\arguments{
\item{n}{the size of the matrix.}

\item{nneigh}{the number of nearest neighbors.}

\item{seed}{an integer to set the seed for the random generated
locations.}
}
\value{
a matrix of class \code{dgCMatrix} (sparse matrix).
}
\description{
Generate a spatial weight matrix of given size and number of nearest 
neighbors from randomly-located observations on the unit square.
}
\details{
The output matrix has zero diagonal and it is row-standardised. 
	The \code{n} observations are allocated randomly in the unit square.  
	For each observation, the \code{nneigh} closests observations w.r.t. the 	
	Euclidean distance are assigned with a weight equal to 1/\code{nneigh}.
}
\examples{
W <- generate_W(100,4,seed=12)
image(W)

}
\seealso{
\code{\link{sim_binomial_probit}}.
}

