% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scoreopt_functions.R
\name{scoreopt.control}
\alias{scoreopt.control}
\title{Tuning parameters for score optimisation by Stochastic Gradient Descent}
\usage{
scoreopt.control(
  eta = 0.001,
  beta1 = 0.9,
  beta2 = 0.999,
  maxIter = 500,
  tol = 1e-04,
  epsilon = 1e-08
)
}
\arguments{
\item{eta}{Learning rate. Deafult is 0.001}

\item{beta1}{Forgetting rate for mean. Default is 0.9.}

\item{beta2}{Forgetting rate for variance. Default is 0.999.}

\item{maxIter}{Maximum number of iterations. Default is 500}

\item{tol}{Tolerance for stopping criterion. Algorithm stops when the change in all parameter values is less than this amount. Default is 0.0001.}

\item{epsilon}{Small constant added to denominator of step size. Default is 1e-8}
}
\description{
Function to set tuning parameters for stochastic gradient descent used to
find a reconciliation matrix that optimises total score.  The defaults are 
those of \insertCite{adam;textual}{ProbReco} and more details on the tuning 
parameters can be found therein.
}
\examples{
#Change Maximum Iterations to 1000
scoreopt.control(maxIter=1000)
}
\references{
\insertAllCited{}
}
\seealso{
Other ProbReco functions: 
\code{\link{inscoreopt}()},
\code{\link{scoreopt}()},
\code{\link{total_score}()}
}
\concept{ProbReco functions}
