% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02PTCell.r, R/03PTTrack.r, R/04PTPattern.r
\docType{methods}
\name{as.character}
\alias{as.character}
\alias{as.character,PTCell-method}
\alias{as.character,PTTrack-method}
\alias{as.character,PTPattern-method}
\title{Character representation of ProTrackR objects}
\usage{
\S4method{as.character}{PTCell}(x)

\S4method{as.character}{PTTrack}(x)

\S4method{as.character}{PTPattern}(x)
}
\arguments{
\item{x}{An object of any of the following classes: \code{\link{PTCell}},
\code{\link{PTTrack}} or \code{\link{PTPattern}}.}
}
\value{
Returns a single character string when \code{x} is of class
\code{\link{PTCell}}.

Returns a \code{vector} of length 64 of the type \code{character} when \code{x} is of class
\code{\link{PTTrack}}.

Returns a 64 by 4 \code{matrix} of the type \code{character} when \code{x} is of class
\code{\link{PTPattern}}.
}
\description{
Create a \code{character} representation of \code{\link{PTCell}},
\code{\link{PTTrack}} or \code{\link{PTPattern}} objects.
}
\details{
A \code{\link{PTCell}} is an element of a \code{\link{PTTrack}} which
in turn is an element of a \code{\link{PTPattern}}. A \code{\link{PTPattern}}
tells a tracker which sample to play at which frequency on which of the
four audio channels and with which effects. A \code{\link{PTCell}} in essence
holds all this information as described at the documentation of
the \code{\link{PTCell-class}}.

Data in these objects are stored in these objects in a \code{raw} form,
to save working memory and to comply to the ProTracker file specifications.
As the raw data is not easy to interpret, this method is provided to
make your life (and the interpretation of the objects) easier.

This method generates a character representation of each of the three objects.
These character representations can be coerced back to their original classes
with the following methods: \code{\link{PTCell-method}},
\code{\link{PTTrack-method}} and \code{\link{PTPattern-method}}.
}
\examples{
data("mod.intro")

as.character(   PTCell(mod.intro, 1, 1, 1))

as.character(PTTrack(mod.intro, 1, 1))

as.character(PTPattern(mod.intro, 1))

}
\seealso{
Other character.operations: 
\code{\link{name}},
\code{\link{periodToChar}()},
\code{\link{rawToCharNull}()},
\code{\link{sampleRate}}

Other track.operations: 
\code{\link{PTTrack-method}}
}
\author{
Pepijn de Vries
}
\concept{character.operations}
\concept{track.operations}
