% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/05PTSample.r
\docType{methods}
\name{loopSample}
\alias{loopSample}
\alias{loopSample,PTSample-method}
\title{Looped waveform of a sample}
\usage{
\S4method{loopSample}{PTSample}(sample, times, n_samples)
}
\arguments{
\item{sample}{A \code{\link{PTSample}} object that needs to be looped.}

\item{times}{A positive \code{integer} value indicating the number of
times a sample loop should be repeated. This argument is ignored if
\code{n_samples} is specified.}

\item{n_samples}{A positive \code{integer} value indicating the desired length
of the looped waveform in number of samples. This argument overrules the
\code{times} argument.}
}
\value{
Returns a \code{\link{waveform}} represented by a \code{numeric}
\code{vector} of values ranging from 0 up to 255. Has a length of
\code{n_samples} when that argument is specified.
}
\description{
Generate a looped \code{\link{waveform}} of a \code{\link{PTSample}} object.
}
\details{
For playing routines, it can be useful to generate repeats of a sample loop.
This method returns the waveform of a \code{\link{PTSample}} where the
loop is repeated `\code{times}' times or has a length of `\code{n_samples}'.
}
\examples{
data("mod.intro")

## Loop sample number 4 10 times:
wform <- loopSample(PTSample(mod.intro, 4), times = 10)
plot(wform, type = "l")

## Loop sample number 4, such that its
## final length is 5000 samples:
wform <- loopSample(PTSample(mod.intro, 4), n_samples = 5000)
plot(wform, type = "l")

}
\seealso{
Other loop.methods: \code{\link{loopLength}},
  \code{\link{loopStart}}, \code{\link{loopState}}

Other sample.operations: \code{\link{PTSample-class}},
  \code{\link{PTSample-method}}, \code{\link{fineTune}},
  \code{\link{loopLength}}, \code{\link{loopStart}},
  \code{\link{loopState}}, \code{\link{name}},
  \code{\link{playSample}}, \code{\link{read.sample}},
  \code{\link{sampleLength}}, \code{\link{volume}},
  \code{\link{waveform}}, \code{\link{write.sample}}
}
\author{
Pepijn de Vries
}
