% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/02PTCell.r
\docType{class}
\name{PTCell-class}
\alias{PTCell}
\alias{PTCell-class}
\title{The PTCell class}
\description{
The \code{PTCell} class is the smallest possible element of a \code{\link{PTPattern}}
table. It holds all information on which note to play, at which frequency,
with which effect and what kind of triggers or jumps should be applied.
}
\details{
The \code{PTCell} class consists of a \code{vector} of four \code{raw} values,
as specified in the `Slots' section. A cell will tell which \code{link{PTSample}}
is to be played at which frequency (corresponding to a note and octave). If
no octave or note is specified, nothing will be played, or if a sample was
started to play on the same \code{\link{PTTrack}}, this sample will continue
playing. The \code{PTCell} can also hold \code{\link{effect}} codes which
can be used to add audio effects to the sample being played, change the
speed/tempo at which patterns are played, or trigger jumps to other positions
within a \code{\link{PTPattern}} or to other positions in the
\code{\link{patternOrder}} table.
}
\section{Slots}{

\describe{
\item{\code{data}}{A \code{vector} of class "\code{raw}" of length 4. The \code{raw}
data is stored identical to the way it is stored in a ProTracker module
file. The \code{character} representation is easier to understand, and
with the \link{ProTrackR} package it shouldn't be necessary to manipulate
the \code{raw} data directly.

The structure is illustrated with an example. Let's start with a
\code{character} representation of a \code{PTCell} as an example: "\code{C-3 1B A08}".
The left-hand part of this string shows that this cell will play note "C" in
octave 3. The middle part shows that \code{\link{PTSample}} number \code{0x1B} = \code{27}
will be played. The right-hand part of the string shows that effect "A08"
will be applied (which is a volume slide down).

The \code{raw} representation of this example would be "\code{10 d6 ba 08}",
or when I replace the actual values with symbols: "\code{sp pp se ee}". Where
"\code{ss}" represents the sample number, "\code{eee}" represents the \code{\link{effect}}
code and "\code{ppp}" represents the period value. The correct note and octave
can be derived by looking op the period value in the \code{\link{period_table}}
(which is also implemented in the following methods: \code{\link{note}},
\code{\link{octave}} and \code{\link{periodToChar}}).
The period value \code{0x0d6} =  \code{214} corresponds with note "C"
in octave 3.}
}}
\note{
This version of the ProTrackR package does not (yet)
implement a player and mixing routine. Although modules
can be edited with the package they cannot be played directly. For now
\href{https://en.wikipedia.org/wiki/Music_tracker#List_of_music_trackers}{external players/trackers}
can be used for this purpose.
}
\examples{
data("mod.intro")

## get the PTCell from mod.intro at
## PTPattern #1, PTTrack #1 and row #1:

cell <- PTCell(mod.intro, 1, 1, 1)

## get the note of this cell:
note(cell)

## get the octave of this cell:
octave(cell)

## get the sampleNumber of this cell:
sampleNumber(cell)

## get the effect code of this cell:
effect(cell)

## get the raw data of this cell:
as.raw(cell)

## get the character representation of this cell:
as.character(cell)
}
\author{
Pepijn de Vries
}
\seealso{
Other cell.operations: \code{\link{PTCell,PTModule,numeric,numeric,numeric-method}},
  \code{\link{PTCell,PTPattern,numeric,numeric,missing-method}},
  \code{\link{PTCell,PTTrack,numeric,missing,missing-method}},
  \code{\link{PTCell,character,missing,missing,missing-method}},
  \code{\link{PTCell,raw,missing,missing,missing-method}},
  \code{\link{PTCell-method}}, \code{\link{PTCell<-}},
  \code{\link{PTCell<-,PTModule,numeric,numeric,numeric,PTCell-method}},
  \code{\link{PTCell<-,PTPattern,numeric,numeric,missing,PTCell-method}},
  \code{\link{PTCell<-,PTTrack,numeric,missing,missing,PTCell-method}},
  \code{\link{PTCell<-,PTTrack,numeric,missing,missing-method}};
  \code{\link{effect}}, \code{\link{effect,PTCell-method}},
  \code{\link{effect<-}},
  \code{\link{effect<-,PTCell,character-method}};
  \code{\link{note}}, \code{\link{note,PTCell-method}},
  \code{\link{note,numeric-method}}, \code{\link{note<-}},
  \code{\link{note<-,PTCell,character-method}};
  \code{\link{sampleNumber}},
  \code{\link{sampleNumber,PTCell-method}},
  \code{\link{sampleNumber<-}},
  \code{\link{sampleNumber<-,PTCell,numeric-method}}
}

