% Generated by roxygen2: do not edit by hand
% Please edit documentation in
%   R/get_recent_personal_explanations_votes_specific_member_by_category.R
\name{get_recent_personal_explanations_votes_specific_member_by_category}
\alias{get_recent_personal_explanations_votes_specific_member_by_category}
\title{Get Recent Personal Explanation Votes by a Specific Member by Category}
\usage{

  get_recent_personal_explanations_votes_specific_member_by_category(member_id,
  congress, category, myAPI_Key)
}
\arguments{
\item{member_id}{The ID of the member to retrieve; it is assigned by the Biographical Directory of the United States Congress or can be retrieved from a member list request.}

\item{congress}{110-115}

\item{category}{options: voted-incorrectly (    Voted yes or no by mistake),    official-business (Away on official congressional business),    ambiguous (No reason given),    travel-difficulties (    Travel delays and issues),    personal (Personal or family reason),    claims-voted (Vote made but not recorded),    medical (    Medical issue for lawmaker, not family),    weather,    memorial,    misunderstanding,    leave-of-absence,    prior-commitment,    election-related,    military-service,    other}

\item{myAPI_Key}{API key from Propublica To use the congress API, you must sign up for an API key.}
}
\value{
List of returned JSON from endpoint that retrieves the 20 most recent personal explanations by a specific member in the specified Congress, and supports paginated requests using multiples of 20.
}
\description{
Lawmakers, mostly in the House but also in the Senate, can make personal explanations for missed or mistaken votes in the Congressional Record. To get recent personal explanations by a specific member that are parsed to individual votes and have an additional category attribute describing the general reason for the absence or incorrect vote, use the following function. HTTP Request: GET https://api.propublica.org/congress/v1/members/{member_id}/explanations/{congress}/votes.json
}
\examples{
\donttest{
get_recent_personal_explanations_votes_specific_member_by_category('S001193', 115, 'personal')
}
}
