% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_current_members_by_statedistrict.R
\name{get_current_members_by_statedistrict}
\alias{get_current_members_by_statedistrict}
\title{Get Current Members by State/District}
\usage{
get_current_members_by_statedistrict(state, chamber, district, myAPI_Key)
}
\arguments{
\item{state}{Two-letter state abbreviation}

\item{chamber}{house or senate}

\item{district}{House of Representatives district number (House requests only). For states with at-large districts (AK, DE, MT, ND, SD, VT, WY), territories (GU, AS, VI, MP), commonwealths (PR) and the District of Columbia, use a district value of 1.}

\item{myAPI_Key}{API key from Propublica To use the congress API, you must sign up for an API key.}
}
\value{
List of returned JSON from endpoint that retrieves biographical and Congressional role information for a particular member of Congress by State/District
}
\description{
Senate Request: GET https://api.propublica.org/congress/v1/members/{chamber}/{state}/current.json
House Request: GET https://api.propublica.org/congress/v1/members/{chamber}/{state}/{district}/current.json
}
\examples{
\donttest{
get_current_members_by_statedistrict( 'MI', 'house', 11)
get_current_members_by_statedistrict( 'RI', 'senate')
}
}
