% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/net.robustness.R
\name{net.robustness}
\alias{net.robustness}
\title{Network robustness}
\usage{
net.robustness(graph, n = 1000, vertex.name = NULL, ...)
}
\arguments{
\item{graph}{An igraph object.}

\item{n}{Number of sampling times. Default value is \code{1000}.}

\item{vertex.name}{A vector of the vertex name.}

\item{...}{Other arguments.}
}
\value{
A matrix of the network parameters by exact and the simulated radom attack.
}
\description{
Test the network robustness after attack.
}
\examples{
nlocal<-data.frame(c("DVL1","DVL2","DVL3"))
net<-construction(input=nlocal,db="HPRD",species="human",ID.type="Gene symbol",hierarchy=1)
net.robustness(net,n=1000,vertex.name=c("DVL1","DVL2","DVL3"))
}
\seealso{
\code{\link{net.attack}}.
}

