% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/extraction.R
\name{extraction}
\alias{extraction}
\title{Subnetwork extraction}
\usage{
extraction(graph, mode = c("exact", "sample"), sample.number = 10,
  nodes = NULL, vertex.name = NULL, vertex.expression = NULL, ...)
}
\arguments{
\item{graph}{An igraph object.}

\item{mode}{Extraction mode, either be \code{exact} or \code{sample}.}

\item{sample.number}{Sampled nodes if \code{mode} is \code{sample}, no more than the total nodes in the network. Default value is \code{10}.}

\item{nodes}{A vector of vertex id to extract the subnetwork if \code{mode} is \code{exact}.}

\item{vertex.name}{A vector of vertex name to extract the subnetwork if \code{mode} is \code{exact}.}

\item{vertex.expression}{Attribute used to choose the vertex and extract the subnetwork.}

\item{...}{Other vertex or edge atrributes.}
}
\value{
An igraph object.
}
\description{
Extract a sub network from the original one.
}
\examples{
g<-graph.ring(100)
g1<-extraction(g,mode="sample",sample.number=5)
}

