% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classifyFun.R
\name{classifyFun}
\alias{classifyFun}
\title{Generic Classification Analyses}
\usage{
classifyFun(Data, classCol, selectedCols, ranges = NULL, tune = FALSE,
  cost = 1, gamma = 0.5, classifierName = "svm",
  genclassifier = Classifier.svm, silent = FALSE, SetSeed = TRUE, ...)
}
\arguments{
\item{Data}{(dataframe) dataframe of the data}

\item{classCol}{(numeric) column number that contains the variable to be predicted}

\item{selectedCols}{(optional) (numeric) all the columns of data that would be used either as predictor or as feature}

\item{ranges}{(optional) (list)  ranges for tuning support vector machine}

\item{tune}{(optional) (logical) whether tuning of svm parameters should be performed or not}

\item{cost}{(optional) (numeric) regularization parameter of svm}

\item{gamma}{(optional) (numeric)  rbf kernel parameter}

\item{classifierName}{(optional) (string) name of the classifier to be used}

\item{genclassifier}{(optional) (function or string) a classifier function or a name (e.g. Classifier.svm)}

\item{silent}{(optional) (logical) whether to print messages on mean accuracy or not}

\item{SetSeed}{(optional) (logical) Whether to setseed or not. use SetSeed to seed the random number generator to get consistent results; 
set false only for permutation tests}

\item{...}{(optional) additional arguments for the function}
}
\value{
Outputs Crossvalidation accuracy \code{acc} and    Test accuracy \code{accTest}
}
\description{
function for performing generic classification Analysis
}
\details{
This function implements Classification Analysis. 
Classification Analysis is a supervised machine learning approach that attempts to identify 
holistic patters in the data and assign to it classes (classification). Given a set of features, 
a classification analysis automatically learns intrinsic patterns in the data to be able to predict 
respective classes. If the data features are informative about the classes, a high classification score
would be achieved.
}
\examples{
#classification analysis with SVM
Results <- classifyFun(Data = KinData,classCol = 1,
selectedCols = c(1,2,12,22,32,42,52,62,72,82,92,102,112))
# output
# [1] "Begining k-fold Classification"
# [1] "Mean CV Accuracy 0.66"
# [1] "Mean Test Accuracy 0.62"

}
\author{
Atesh Koul, C'MON unit, Istituto Italiano di Tecnologia

\email{atesh.koul@iit.it}
}

