/*
 * Decompiled with CFR 0.152.
 */
package org.openfast.template.serializer;

import org.openfast.template.Field;
import org.openfast.template.serializer.SerializerRegistry;
import org.openfast.util.XmlWriter;

public class SerializingContext {
    private final SerializingContext parent;
    private String currentNamespace = "";
    private String currentTemplateNamespace = "";
    private String dictionary = "global";

    public SerializingContext(SerializingContext parent) {
        this.parent = parent;
    }

    public static SerializingContext createInitialContext(final SerializerRegistry registry) {
        return new SerializingContext(null){

            public SerializerRegistry getSerializerRegistry() {
                return registry;
            }
        };
    }

    public void serialize(XmlWriter writer, Field field) {
        this.getSerializerRegistry().getSerializer(field).serialize(writer, field, this);
    }

    public SerializerRegistry getSerializerRegistry() {
        return this.parent.getSerializerRegistry();
    }

    public String getNamespace() {
        return this.currentNamespace;
    }

    public String getTemplateNamespace() {
        return this.currentTemplateNamespace;
    }

    public String getDictionary() {
        return this.dictionary;
    }

    public void setTemplateNamespace(String templateNamespace) {
        this.currentTemplateNamespace = templateNamespace;
    }

    public void setNamespace(String namespace) {
        this.currentNamespace = namespace;
    }
}

