/*
 * Decompiled with CFR 0.152.
 */
package com.portfolioeffect.quant.client.portfolio.optimizer;

import com.portfolioeffect.quant.client.portfolio.Portfolio;
import com.portfolioeffect.quant.client.portfolio.optimizer.ForecastedValues;
import com.portfolioeffect.quant.client.portfolio.optimizer.PortfolioOptimizer;
import com.portfolioeffect.quant.client.result.MethodResult;
import java.util.HashMap;

public class StrategyOptimizer
extends PortfolioOptimizer {
    private String forecasterType = "exp_smoothing";
    private String forecastPortfolioWindow = "";
    private String forecastExpWindow = "";
    private ForecastedValues forecastedValue = null;

    public StrategyOptimizer(Portfolio portfolio, double localOptimStopStep, double globalOptimProbability) {
        super(portfolio, localOptimStopStep, globalOptimProbability);
    }

    public StrategyOptimizer(Portfolio portfolio) {
        super(portfolio);
    }

    public void setForecastedValue(ForecastedValues forecastedValue) {
        this.forecastedValue = forecastedValue;
    }

    @Override
    public MethodResult getOptimizedPortfolio(boolean isResultSelfPortfolio) throws Exception {
        MethodResult checkResult;
        Portfolio optimizedPortfolio;
        try {
            HashMap<String, String> forecastParams = new HashMap<String, String>();
            forecastParams.put("section", "FORECAST_PARAMS");
            forecastParams.put("type", this.forecasterType);
            forecastParams.put("forecastPortfolioWindow", this.forecastPortfolioWindow);
            forecastParams.put("forecastExpWindow", this.forecastExpWindow);
            this.paramsBuffer.add(forecastParams);
            optimizedPortfolio = this.optimizationInit(isResultSelfPortfolio);
        }
        catch (Exception e1) {
            return new MethodResult(e1.getMessage());
        }
        if (this.forecastedValue != null && (checkResult = this.forecastedValue.addToPortfolio(optimizedPortfolio)).hasError()) {
            return new MethodResult(checkResult.getErrorMessage());
        }
        return this.makeOptimization(optimizedPortfolio);
    }

    public String getForecasterType() {
        return this.forecasterType;
    }

    public void setForecasterType(String forecasterType) {
        this.forecasterType = forecasterType;
    }

    public String getForecastPortfolioWindow() {
        return this.forecastPortfolioWindow;
    }

    public void setForecastPortfolioWindow(String forecastPortfolioWindow) {
        this.forecastPortfolioWindow = forecastPortfolioWindow;
    }

    public String getForecastExpWindow() {
        return this.forecastExpWindow;
    }

    public void setForecastExpWindow(String forecastExpWindow) {
        this.forecastExpWindow = forecastExpWindow;
    }
}

