% Generated by roxygen2 (4.0.1): do not edit by hand
\name{convertToPhenot}
\alias{convertToPhenot}
\title{Convert a genotype allele dataset to a phenotype dataset}
\usage{
convertToPhenot(adata)
}
\arguments{
\item{adata}{data frame: a genotypic allele dataset.}
}
\value{
A data frame, containing the phenotypic form of the
original genotypic dataset.
}
\description{
Convert a 'genotypic' dataset (marker dosages known) to
a 'phenotypic' dataset (marker dosages not known, unique alleles
appear only once in each allele set).
}
\details{
In the terminology used by the PolyPatEx package, a 'genotypic'
allele dataset is one where marker dosages are known, hence any
locus at which fewer than p (the ploidy) alleles are detected is
incomplete (and subsequently ignored by the genotype-specific
routines in this package). A 'phenotypic' allele dataset is one
where marker dosages are not known, hence individual alleles
appear only once in an allele set, and a complete allele set can
contain between \eqn{1} and \eqn{p} alleles.

\code{convertToPhenot} converts a genotypic dataset to a
phenotypic dataset, simply by removing any allele duplicates from
each allele set.  This is probably not something many will want to
do, since one loses considerable information in the process...
}
\examples{
## Using the example dataset 'FR_Genotype':
data(FR_Genotype)

## Since we did not load this dataset using inputData(), we must
## first process it with preprocessData() before doing anything
## else:
gData <- preprocessData(FR_Genotype,
                        numLoci=7,
                        ploidy=4,
                        dataType="genotype",
                        dioecious=TRUE,
                        mothersOnly=TRUE)

head(gData)  ## Checked and Cleaned version of FR_Genotype

pData <- convertToPhenot(gData)

head(pData)
}
\author{
Alexander Zwart (alec.zwart at csiro.au)
}

