% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeLhoods.R
\name{makeLhoods}
\alias{makeLhoods}
\title{\emph{makeLhoods}: function to make likelihoods.}
\usage{
makeLhoods(
  data,
  formula,
  family,
  mesh,
  ips,
  paresp,
  ntrialsvar,
  markstrialsvar,
  speciesname,
  speciesindex,
  samplers,
  pointcovs = NULL
)
}
\arguments{
\item{data}{A list of sf objects containing the datasets for which likelihoods need to be constructed.}

\item{formula}{A list of formulas to add to the likelihoods.}

\item{family}{A list of vectors containing the families within each dataset.}

\item{mesh}{An inla.mesh object.}

\item{ips}{Integration points used.}

\item{paresp}{The response variable name for the presence absence datasets.}

\item{ntrialsvar}{The trials variable name for the presence absence datasets.}

\item{markstrialsvar}{The trial variable name for the binomial marks.}

\item{speciesname}{The name of the species variable used.}

\item{speciesindex}{A vector containing the numeric index of where the species occurs in the data}

\item{samplers}{A list of integration domains for the datasets.}

\item{pointcovs}{A vector of the point covariates used in the model.}
}
\description{
Function to make the datasets into likelihoods.
}
