% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select.mtd.pop.R
\name{select.mtd.pop}
\alias{select.mtd.pop}
\title{Maximum tolerated dose (MTD) selection for single-agent trials}
\usage{
select.mtd.pop(target, n.pts, n.tox)
}
\arguments{
\item{target}{the target DLT rate}

\item{n.pts}{a vector containing the number of patients treated at each dose level}

\item{n.tox}{a vector containing the number of patients who experienced dose-limiting
toxicity at each dose level}
}
\value{
\code{select.mtd.pop()} returns (1) selected MTD (\code{$MTD}),
(2) isotonic estimate of the DLT probablity at each dose and associated
}
\description{
Select the maximum tolerated dose (MTD) when the single-agent trial is completed
}
\examples{

### select the MTD for PoP trial
n <- c(3, 3, 15, 9, 0)
y <- c(0, 0, 4, 4, 0)
selmtd <- select.mtd.pop(target=0.3,n.pts=n, n.tox=y)
summary(selmtd)
plot(selmtd)

}
