% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_ftir.R
\name{plot_ftir_core}
\alias{plot_ftir_core}
\title{PlotFTIR core plot generator}
\usage{
plot_ftir_core(
  ftir,
  plot_title = "FTIR Spectra",
  legend_title = "Sample ID",
  lang = "en"
)
}
\arguments{
\item{ftir}{A data.frame in long format with columns `sample_id`,
  `wavenumber`, and `absorbance`. The `absorbance` column may be replaced by
  a `transmittance` column for transmittance plots. The code determines the
  correct y axis units and labels the plot/adjusts the margins appropriately.

  Un data.frame au format long avec les colonnes `sample_id`, `wavenumber`,
  et `absorbance`. La colonne `absorbance` peut être remplacée par une
  colonne `transmittance` pour les tracés de transmission. Le code détermine
  les unités correctes de l'axe y et étiquette le tracé/ajuste les marges de
  manière appropriée.}

\item{plot_title}{A title for a plot. Defaults to "FTIR Spectra". If a vector
  length two, the second element will be used for a subtitle.

  Un titre pour une trace. La valeur par défaut est «FTIR Spectra». Si un
  vecteur mesure deux, le deuxième élément sera utilisé pour un sous-titre.}

\item{legend_title}{A title for the legend. Defaults to "Sample ID".

  Un titre pour la légende. La valeur par défaut est «Sample ID».}

\item{lang}{An optional argument for language. If set to one of `fr`,
  `french`, `francais`, or `français` the axis and default plot and legend
  titles will change to french. If non-default legend or plot titles are
  provided they are used as-is. Can also provide `en`, `english` or
  `anglais`.

  Un argument optionnel pour la langue. S'il vaut `Fr`, `French`, `Francais`,
  ou `Français`, l'axe et les titres par défaut de le tracé et du légende
  seront en français. Si des titres du légende ou de tracé autres que ceux
  par défaut sont fournis, ils seront utilisés tels quels.}
}
\value{
a ggplot object containing a  FTIR spectral plot. The plot and legend
  titles are as provided, with each sample provided a different default
  color. Because this is a ggplot object, any other ggplot modifiers, layers,
  or changes can be applied to the returned object. Further manipulations can
  be performed by this package. Peut également fournir `en`, `english` ou
  `anglais`.

  un objet ggplot contenant un tracé spectral IRTF. Les titres de le tracé et
  de la légende sont tels que fournis, avec une couleur par défaut différente
  pour chaque échantillon. Puisqu'il s'agit d'un objet ggplot, tous les
  autres modificateurs, calques ou changements ggplot peuvent être appliqués
  à l'objet retourné. D'autres manipulations peuvent être effectuées par ce
  package.
}
\description{
Plot the FTIR spectra in a journal prepared format. Call
  [plot_ftir()] for basic (overlaid) plots and [plot_ftir_stacked()] for
  stacked and offset plots.

  Tracez les spectres IRTF dans un format préparé par un journal. Appelez
  [plot_ftir()] pour les tracés de base (superposés) et [plot_ftir_stacked()]
  pour les tracés empilés et décalés.
}
\seealso{
[zoom_in_on_range()] to 'zoom' into a specified range,
  [compress_low_energy()] to make the x axis non-linear (compressing lower
  energy regions), [add_wavenumber_marker()] to add markers to highlight
  important wavenumbers, and [move_plot_legend()] to modify the legend
  position.

  [zoom_in_on_range()] pour 'zoomer' sur une gamme spécifiée,
  [compress_low_energy()] pour rendre l'axe x non linéaire (en compression
  les régions à basse énergie), [add_wavenumber_marker()] pour ajouter des
  marqueurs afin de mettre en évidence les nombres d'ondes importants, et
  [move_plot_legend()] pour modifier la position de la légende.
}
\keyword{internal}
