% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Spatial_selection_of_cells_on_image.R
\name{Spatial_selection_of_cells_on_image}
\alias{Spatial_selection_of_cells_on_image}
\title{Allows to select an area on the spatial image and to isolate the cells expressed on this part and repeat this process several times.}
\usage{
Spatial_selection_of_cells_on_image(
  vgm_VDJ,
  alpha,
  bcs_merge,
  images_tibble,
  sample_names,
  nbpoints,
  title,
  size,
  plotting
)
}
\arguments{
\item{vgm_VDJ}{Data frame containing all the data on the cell. It must contain the column clonotype_id which describes the number of the clonotype to which the cell belongs. This data frame can be obtained by the assignment functions (VDJ_assignment_random_based, VDJ_assignment_density_based and VDJ_assignment_germline_based).}

\item{alpha}{Number that give the transparency coefficient (value between 0 and 1). If it is not given it will automatically be 0.}

\item{bcs_merge}{Data frame containing imagerow, imagecol and barcode of the cells belonging to the spatial image. It can also be created by the function scaling_spatial_image_parameter by selecting the output parameter 10.}

\item{images_tibble}{Tbl-df containing the sample name, grob, height and width of the spatial image. It can also be created by the function scaling_spatial_image_parameter by selecting the output parameter 5.}

\item{sample_names}{Character vector containing the name of the sample.}

\item{nbpoints}{Numerical value that limite the maximum number of mouse click for the selection, default = 100.}

\item{title}{Character vector to name the plot.}

\item{size}{Number, to define the size of the text, default = 15.}

\item{plotting}{Character vector to return (TRUE) or not (FALSE) the plot of the selection}
}
\value{
If plotting = TRUE, returns a list containing [[1]] the plot of the selected cells according to their group, [[2]] a data frame that contains all the cells but the selected cells are distinguished. If plotting = FALSE it juste returns the dataframe.
}
\description{
Allows to select an area on the spatial image and to isolate the cells expressed on this part and repeat this process several times.
}
\examples{
\dontrun{
test<-Spatial_selection_of_cells_on_image(
vgm_VDJ = vgm_spatial_simulated$VDJ$B_cells$random_BCR_assignment,
images_tibble = scaling_parameters[[5]],
bcs_merge = scaling_parameters[[10]],sample_names = sample_names,
plotting = TRUE)
}
}
