% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AntibodyForests_infer_ancestral.R
\name{AntibodyForests_infer_ancestral}
\alias{AntibodyForests_infer_ancestral}
\title{Creates phylogenetic trees, infers ancestral sequences, and converts the resulting trees into igraph objects.}
\usage{
AntibodyForests_infer_ancestral(
  trees,
  alignment.method,
  iqtree.directory,
  collapse.trees,
  parallel
)
}
\arguments{
\item{trees}{AntibodyForests object/list of AntibodyForests objects - the resulting sequence similarity or minimum spanning tree networks from the AntibodyForests function.}

\item{alignment.method}{string - method/software to perform multiple sequence alignment before the ancestral sequence reconstruction step. Options include: 'mafft' (requires the MAFFT software to be locally installed beforehand), 'clustal', 'clustalomega', 'tcoffee', 'muscle', which all require the 'ape' R package.}

\item{iqtree.directory}{string - path to the IQ-TREE software directory.}

\item{collapse.trees}{boolean - if T, will collapse the resulting phylogenetic trees if an intermediate daughter sequence/node is the same as its parent.}

\item{parallel}{boolean - whether to execute the main subroutine in parallel or not. Requires the 'parallel' R package to be installed.}
}
\value{
nested list of AntibodyForests objects or single AntibodyForests object, with a modified tree slot including the phylogenetic tree converted into igraph objects and the reconstructed intermediate/ancestral sequences.
}
\description{
Phylogenetic trees and ancestral sequence reconstruction is performed using the IQ-TREE software. The IQ-TREE directory is required beforehand.
}
\examples{
\dontrun{
AntibodyForests_infer_ancestral(trees, alignment.method = 'mafft',
igtree.directoty = '/Users/.../Desktop/iqtree-1.6.12-MacOSX')
}
}
